/*
* hal_disp_irq.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/

#ifndef _HAL_DISP_IRQ_H_
#define _HAL_DISP_IRQ_H_

//-------------------------------------------------------------------------------------------------
//  Defines & Macro
//-------------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------------
//  structure & Enum
//-------------------------------------------------------------------------------------------------
typedef enum
{
    E_HAL_DISP_IRQ_IOCTL_ENABLE,
    E_HAL_DISP_IRQ_IOCTL_GET_FLAG,
    E_HAL_DISP_IRQ_IOCTL_CLEAR,

    E_HAL_DISP_IRQ_IOCTL_INTERNAL_SUPPORTED,
    E_HAL_DISP_IRQ_IOCTL_INTERNAL_GET_ID,
    E_HAL_DISP_IRQ_IOCTL_INTERNAL_ENABLE,
    E_HAL_DISP_IRQ_IOCTL_INTERNAL_GET_FLAG,
    E_HAL_DISP_IRQ_IOCTL_INTERNAL_CLEAR,
    E_HAL_DISP_IRQ_IOCTL_INTERNAL_GET_STATUS,

    E_HAL_DISP_IRQ_IOCTL_VGA_HPD_SUPPORTED,
    E_HAL_DISP_IRQ_IOCTL_VGA_HPD_GET_ID,
    E_HAL_DISP_IRQ_IOCTL_VGA_HPD_ENABLE,
    E_HAL_DISP_IRQ_IOCTL_VGA_HPD_GET_FLAG,
    E_HAL_DISP_IRQ_IOCTL_VGA_HPD_CLEAR,
    E_HAL_DISP_IRQ_IOCTL_VGA_HPD_GET_STATUS,
    E_HAL_DISP_IRQ_IOCTL_NUM,
}HalDispIrqIoCtlType_e;

typedef enum
{
    E_HAL_DISP_IRQ_TYPE_NONE                    = 0x0000,
    E_HAL_DISP_IRQ_TYPE_VSYNC                   = 0x0001,
    E_HAL_DISP_IRQ_TYPE_VDE                     = 0x0002,
    E_HAL_DISP_IRQ_TYPE_INTERNAL_VDE_NEGATIVE   = 0x0100,
    E_HAL_DISP_IRQ_TYPE_INTERNAL_VDE_POSITIVE   = 0x0200,
    E_HAL_DISP_IRQ_TYPE_INTERNAL_VSYNC_NEGATIVE = 0x0400,
    E_HAL_DISP_IRQ_TYPE_INTERNAL_VSYNC_POSITIVE = 0x0800,
    E_HAL_DISP_IRQ_TYPE_VGA_HPD_ON              = 0x1000,
    E_HAL_DISP_IRQ_TYPE_VGA_HPD_OFF             = 0x2000,
}HalDispIrqType_e;



typedef struct
{
    HalDispIrqIoCtlType_e enType;
    void *pParam;
}HalDispIrqIoctlConfig_t;
//-------------------------------------------------------------------------------------------------
//  Prototype
//-------------------------------------------------------------------------------------------------
#ifdef _HAL_DISP_IRQ_C_
#define INTERFACE

#else
#define INTERFACE extern
#endif

INTERFACE bool HalDispIrqIoCtl(HalDispIrqIoCtlType_e enIoctlType, HalDispIrqType_e enIrqType, void *pCfg);
INTERFACE void HalDispIrqSetDacEn(u8 u8Val);

#undef INTERFACE

#endif
